#include <cstring>
#include <iostream>
using std::cout;
using std::endl;
 
void decorate(char decoration, int count, 
                const char * original, char *altered) {
    int spaceNeeded = strlen(original) + 2*count;
    int i;
    for (i=0; i<count; ++i) altered[i] = decoration;
    for (i=i; i<count+strlen(original); ++i) 
        altered[i] = original[i-count];
    // We could replace the above loop by 
    //     strcpy(&altered[i], original);
    for (i=i; i<spaceNeeded; ++i) altered[i] = decoration;
    altered[i] = '\0';
}
 
int main() {
    char message[] = "Happy Birthday!";
    const int asteriskCount = 5;
    char buffer[sizeof(message)+2*asteriskCount+1];
    decorate('*', asteriskCount, message, buffer);
    cout << buffer << endl;
    return 0;
}
